/* ============ */
/* clsnprob.c	*/
/* ============ */
#include <stdio.h>
#include <clsndefs.h>
static  double	ClsnProbs[16385];
/* ==================================================================== */
/* CalcCollisionProbs - Determines Distribution of Number of Collisions	*/
/* ==================================================================== */
void
CalcCollisionProbs(CLSN_DATA_STRU * ClsnData)
{
    ULONG   j, j0, j1, k;
    double  Prob;
    int     Tidx;

    for (k = 0; k < 16385; ++k)
    {
	ClsnProbs[k] = 0;
    }

    ClsnProbs[1] = 1.0;

    j0 = j1 = 1;

    for (k = 1; k < ClsnData->NumObs; ++k)
    {
	++j1;
	for (j = j1; j >= j0; --j)
	{
	    ClsnProbs[j] = (double)
		(1.0/(double)ClsnData->NumCategories) *
		(j * ClsnProbs[j] +
		((ClsnData->NumCategories + 1 - j) *
		  ClsnProbs[j-1]));

	    if (ClsnProbs[j] < 1.0e-20)
	    {
		ClsnProbs[j] = 0;

		if (j == j1)
		{
		    --j1;
		}
		else if (j == j0)
		{
		    ++j0;
		}
	    }
	}
    }

    Prob = 0;
    Tidx = 0;

    for (j = j0; j < j1; ++j)
    {
	Prob += ClsnProbs[j];

	while (Prob > ClsnData->PctPts[Tidx] && Tidx < TMAX)
	{
	    ClsnData->ClsnProbs[Tidx] = 1 - Prob;
	    ClsnData->ClsnStats[Tidx] = ClsnData->NumObs - (int)j - 1;
	    ++Tidx;
	}
	if (Tidx >= TMAX)
	{
	    break;
	}
    }
}
